package gov.va.med.mhv.sm.admin.repository;

import java.util.Collection;

import gov.va.med.mhv.sm.admin.model.Folder;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;


@Repository
public interface FolderRepository extends JpaRepository<Folder, Long>{
	
	/**
	 * findFodlerById
	 * @param id
	 * @return Folder
	 */
	@Query("select folder from Folder folder where folder.id = :id")
	Folder findFolderById(@Param("id") Long id);

	@Query("select f from Folder as f where f.userId = :userId and active=1 order by upper(f.name)")
	Collection<Folder> getFoldersForUser(@Param("userId") Long userId);
	
	
}